/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.data.CfgItemOptions;
import frc.emul.config.handler.CLHConfiguration;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import org.xml.sax.Attributes;

public class CLHOverall
extends ConfigLoaderHandler {
    private final Level level;

    public CLHOverall(CLHConfiguration cLHConfiguration) {
        super(cLHConfiguration);
        this.level = Level.ROOT;
    }

    private CLHOverall(CLHOverall cLHOverall, Level level) {
        super(cLHOverall);
        this.level = level;
    }

    public void pushed(Attributes attributes) {
        CfgItemOptions cfgItemOptions = this.getConfig().options;
        String string = CLHOverall.loadStr(attributes, "id", null);
        switch (this.level) {
            case FOLDER: {
                String string2 = CLHOverall.loadStr(attributes, "path", "");
                if (string2.length() <= 0) break;
                if ("injection".equals(string)) {
                    cfgItemOptions.lastPathInjections = string2;
                    break;
                }
                if ("saves".equals(string)) {
                    cfgItemOptions.lastPathUserSaves = string2;
                    break;
                }
                if (!"snapshots".equals(string)) break;
                cfgItemOptions.lastPathSnapshots = string2;
                break;
            }
            case OPTION: {
                if ("firstRun".equals(string)) {
                    cfgItemOptions.firstRun = CLHOverall.loadBool(attributes, "value", cfgItemOptions.firstRun);
                    break;
                }
                if (!"toggleMenuHelp".equals(string)) break;
                cfgItemOptions.hideMenuHelp = CLHOverall.loadBool(attributes, "value", cfgItemOptions.hideMenuHelp);
            }
        }
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        if (Level.ROOT == this.level) {
            if (string.equals("folder")) {
                return new CLHOverall(this, Level.FOLDER);
            }
            if (string.equals("option")) {
                return new CLHOverall(this, Level.OPTION);
            }
        }
        return super.getChildHandler(string, attributes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Level {
        ROOT,
        FOLDER,
        OPTION;

    }
}

